﻿/*
 * Copyright (C)  2013  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.Diagnostics;
using System.Windows.Forms;

namespace plexdata.Utilities
{
    public static class RtfHelper
    {
        // Obviously, there is no other way to easily convert plain text 
        // into RTF format, except to use a RichTextBox as helper.
        private static RichTextBox rtfBox = null;

        public static string FromRtf(string value)
        {
            try
            {
                if (RtfHelper.IsRtf(value))
                {
                    if (rtfBox == null) { rtfBox = new RichTextBox(); }

                    rtfBox.Rtf = value;
                    return rtfBox.Text;
                }
                else
                {
                    return value;
                }
            }
            catch (Exception exception)
            {
                Debug.WriteLine(exception);
                return String.Empty;

            }
        }

        public static string ToRtf(string value)
        {
            try
            {
                if (rtfBox == null) { rtfBox = new RichTextBox(); }

                rtfBox.Text = value;
                return rtfBox.Rtf;
            }
            catch (Exception exception)
            {
                Debug.WriteLine(exception);
                return String.Empty;

            }
        }

        public static bool IsRtf(string value)
        {
            return value != null && value.TrimStart().StartsWith("{\\rtf", StringComparison.OrdinalIgnoreCase);
        }
    }
}
