﻿/*
 * Copyright (C)  2013  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.Drawing;
using System.Drawing.Imaging;

namespace plexdata.ImageViewer
{
    // The code of this class was inspired by a very useful implementation of an EXIF extractor. 
    // The complete implementation of this extractor can be found on the Internet under the link 
    // shown below. Many thanks to this guy because he saved my time.
    // http://www.codeproject.com/Articles/11305/EXIFextractor-library-to-extract-EXIF-information
    internal static class RotateImageHelper
    {
        public static Image RotateFlip(Image image)
        {
            if (image != null)
            {
                foreach (PropertyItem property in image.PropertyItems)
                {
                    // ID tag: orientation.
                    if (property.Id == 0x00000112)
                    {
                        // Value type: 16-bit (2 byte) unsigned integer.
                        if (property.Type == 0x0003)
                        {
                            if (property.Value.Length == 2)
                            {
                                RotateFlipType flip = RotateImageHelper.ConvertOrientation(
                                    Convert.ToUInt16(property.Value[1] << 8 | property.Value[0]));

                                // Rotate image only if necessary.
                                if (flip != RotateFlipType.RotateNoneFlipNone)
                                {
                                    image.RotateFlip(flip);
                                }
                            }
                        }
                        break; // Done! End the loop...
                    }
                }
            }

            return image;
        }

        private static RotateFlipType ConvertOrientation(int orientation)
        {
            switch (orientation)
            {
                case 1:
                    return RotateFlipType.RotateNoneFlipNone;
                case 2:
                    return RotateFlipType.RotateNoneFlipX;
                case 3:
                    return RotateFlipType.Rotate180FlipNone;
                case 4:
                    return RotateFlipType.Rotate180FlipX;
                case 5:
                    return RotateFlipType.Rotate90FlipX;
                case 6:
                    return RotateFlipType.Rotate90FlipNone;
                case 7:
                    return RotateFlipType.Rotate270FlipX;
                case 8:
                    return RotateFlipType.Rotate270FlipNone;
                default:
                    return RotateFlipType.RotateNoneFlipNone;
            }
        }
    }
}
