﻿/*
 * Copyright (C)  2013  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.IO;
using System.Diagnostics;
using System.Windows.Forms;

using plexdata.Controls;
using plexdata.Utilities;

namespace plexdata.ImageViewer
{
    public class NotesPanel : Panel
    {
        public readonly string DefaultNotesExtension = ".rtf";

        private TextEditor notesEditor;

        public NotesPanel()
            : base()
        {
            this.InitializeComponent();
        }

        public string Filename
        {
            get
            {
                return this.filename;
            }
            private set
            {
                try
                {
                    if (!String.IsNullOrEmpty(value))
                    {
                        if (String.Compare(Path.GetExtension(value), this.DefaultNotesExtension, true) != 0)
                        {
                            this.filename = Path.ChangeExtension(value, this.DefaultNotesExtension);
                        }
                        else
                        {
                            this.filename = value;
                        }
                    }
                    else
                    {
                        this.filename = String.Empty;
                    }
                }
                catch (Exception exception)
                {
                    Debug.WriteLine(exception);
                    this.filename = String.Empty;
                }
            }
        }
        private string filename = String.Empty;

        public void LoadNotes(string filename)
        {
            string content = String.Empty;
            try
            {
                if (this.notesEditor.Modified)
                {
                    // Save notes using current file.
                    this.SaveNotes(this.Filename);
                }

                // Save new file name.
                this.Filename = filename;

                // Load notes from new file.
                if (File.Exists(this.Filename))
                {
                    using (StreamReader reader = new StreamReader(this.Filename))
                    {
                        content = reader.ReadToEnd();
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.WriteLine(exception);
            }

            this.notesEditor.Text = content;
            this.notesEditor.Modified = false;
        }

        public void SaveNotes()
        {
            this.SaveNotes(this.Filename);
        }

        public void SaveNotes(string filename)
        {
            try
            {
                if (!String.IsNullOrEmpty(filename))
                {
                    if (String.Compare(Path.GetExtension(filename), this.DefaultNotesExtension, true) != 0)
                    {
                        filename = Path.ChangeExtension(filename, this.DefaultNotesExtension);
                    }

                    string content = this.notesEditor.Text;

                    if (!String.IsNullOrEmpty(content))
                    {
                        using (StreamWriter writer = new StreamWriter(filename, false))
                        {
                            writer.Write(content);
                        }
                    }
                    else
                    {
                        if (File.Exists(filename))
                        {
                            File.Delete(filename);
                        }
                    }

                    this.notesEditor.Modified = false;
                }
            }
            catch (Exception exception)
            {
                Debug.WriteLine(exception);
            }
        }

        private void InitializeComponent()
        {
            this.notesEditor = new TextEditor();
            this.notesEditor.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.notesEditor.Dock = System.Windows.Forms.DockStyle.Fill;
            this.notesEditor.Name = "notesEditor";
            this.notesEditor.ToolbarHidden = true;
            this.notesEditor.TabIndex = 0;
            this.Controls.Add(this.notesEditor);
        }
    }
}
