﻿/*
 * Copyright (C)  2012  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.Windows.Forms;

using System.Diagnostics;
using System.IO;

namespace plexdata.ImageViewer
{
    partial class MainForm
    {
        private void InitializeTreeview()
        {
            this.imageNavigator.InitializeRootNodes();
            this.imageNavigator.AfterSelect += this.ImageNavigatorAfterSelect;
        }

        private void ImageNavigatorAfterSelect(object sender, TreeViewEventArgs args)
        {
            args.Node.EnsureVisible();
            this.lblPrimaryStatus.Text = args.Node.ToolTipText;
        }
    }
}
