﻿/*
 * Copyright (C)  2012  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.Diagnostics;
using System.Windows.Forms;

namespace plexdata.ImageViewer
{
    public partial class SettingsPanelSlideshow : SettingsPanelBase
    {
        public SettingsPanelSlideshow(Control reference, Settings settings)
            : base()
        {
            this.InitializeComponent();

            this.Size = reference.Size;
            this.Location = reference.Location;
            this.TabIndex = reference.TabIndex;

            this.settings = settings;
            this.LoadSettings();
        }

        #region Inherited member function reimplementation.

        public override bool LoadSettings()
        {
            try
            {
                // Load slideshow settings.
                this.btnBackground.Color = this.settings.Slideshow.BackColor;
                this.chkRepeated.Checked = this.settings.Slideshow.Repeated;
                this.chkInterpolation.Checked = this.settings.Slideshow.Interpolation;
                this.chkSuspended.Checked = this.settings.Slideshow.Suspended;
                this.numPadding.Value = this.settings.Slideshow.ImagePadding;
                this.numInterval.Value = this.settings.Slideshow.Interval / 1000;

                return true;
            }
            catch (Exception exception)
            {
                base.ErrorMessage = exception.Message;
                Debug.WriteLine(exception);
                return false;
            }
        }

        public override bool SaveSettings()
        {
            base.ErrorMessage = String.Empty;

            try
            {
                this.settings.Slideshow.BackColor = this.btnBackground.Color;
                this.settings.Slideshow.Repeated = this.chkRepeated.Checked;
                this.settings.Slideshow.Interpolation = this.chkInterpolation.Checked;
                this.settings.Slideshow.Suspended = this.chkSuspended.Checked;
                this.settings.Slideshow.Interval = this.GetValue(this.numInterval) * 1000;
                this.settings.Slideshow.ImagePadding = this.GetValue(this.numPadding);

                return true;
            }
            catch (Exception exception)
            {
                base.ErrorMessage = exception.Message;
                Debug.WriteLine(exception);
                return false;
            }
        }

        public override bool DefaultSettings()
        {
            this.settings.Slideshow = new Slideshow();
            return this.LoadSettings();
        }

        #endregion // Inherited member function reimplementation.

        #region Dialog event handler implementation.

        private void btnBackground_Click(object sender, EventArgs args)
        {
            ColorDialog dialog = new ColorDialog();
            dialog.Color = this.btnBackground.Color;
            if (DialogResult.OK == dialog.ShowDialog(this))
            {
                this.btnBackground.Color = dialog.Color;
            }
        }

        #endregion // Dialog event handler implementation.

        #region Private helper function implementation.

        private int GetValue(NumericUpDown numBox)
        {
            return Convert.ToInt32(numBox.Value);
        }

        #endregion // Private helper function implementation.
    }
}
