﻿/*
 * Copyright (C)  2012  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.Windows.Forms;
using System.ComponentModel;

namespace plexdata.ImageViewer
{
    public partial class SettingsPanelBase : UserControl
    {
        protected Settings settings = null;

        protected SettingsPanelBase()
            : base()
        {
            this.InitializeComponent();
        }

        protected SettingsPanelBase(string name)
            : this()
        {
            this.Text = name;
        }

        [Browsable(true)]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        public override string Text
        {
            get
            {
                return base.Text;
            }
            set
            {
                base.Text = value;
            }
        }

        public Control ValueMember { get { return this; } }

        public string DisplayMember { get { return this.Text; } }

        public string ErrorMessage { get; protected set; }

        public virtual bool LoadSettings()
        {
            throw new NotImplementedException("Member function LoadSettings() must be implemented.");
        }

        public virtual bool SaveSettings()
        {
            throw new NotImplementedException("Member function SaveSettings() must be implemented.");
        }

        public virtual bool DefaultSettings()
        {
            throw new NotImplementedException("Member function DefaultSettings() must be implemented.");
        }
    }
}
