﻿/*
 * Copyright (C)  2013  Axel Kesseler
 * 
 * This software is free and you can use it for any purpose. Furthermore, 
 * you are free to copy, to modify and/or to redistribute this software.
 * 
 * In addition, this software is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 */

using System;
using System.Drawing;
using System.Windows.Forms;

namespace plexdata.Controls
{
    public class GripSplitContainer : SplitContainer
    {
        public GripSplitContainer()
            : base()
        {
            this.DoubleBuffered = true;
            this.SplitterWidth = 6;
        }

        protected override void OnSizeChanged(EventArgs args)
        {
            base.OnSizeChanged(args);

            // BUGFIX: Update needed after changing the control's size.
            Region update = new Region(this.Bounds);
            update.Exclude(this.Panel1.Bounds);
            update.Exclude(this.Panel2.Bounds);
            this.Invalidate(update, false);
        }

        protected override void OnPaint(PaintEventArgs args)
        {
            // It might be useful to have an additional rectangle 
            // around those points. But be aware less is more.
            Point[] points = new Point[3];

            // Calculate points position.
            if (this.Orientation == Orientation.Horizontal)
            {
                // Middle, Left, Right...
                points[0] = new Point((this.Width / 2), this.SplitterDistance + (this.SplitterWidth / 2));
                points[1] = new Point(points[0].X - 7, points[0].Y);
                points[2] = new Point(points[0].X + 7, points[0].Y);
            }
            else
            {
                // Middle, Upper, Lower...
                points[0] = new Point(this.SplitterDistance + (this.SplitterWidth / 2), (this.Height / 2));
                points[1] = new Point(points[0].X, points[0].Y - 7);
                points[2] = new Point(points[0].X, points[0].Y + 7);
            }

            foreach (Point point in points)
            {
                point.Offset(-2, -2);
                args.Graphics.FillEllipse(SystemBrushes.ControlDark, new Rectangle(point, new Size(3, 3)));

                point.Offset(1, 1);
                args.Graphics.FillEllipse(SystemBrushes.ControlLight, new Rectangle(point, new Size(3, 3)));
            }
        }
    }
}
